package com.zjty.fp.acq.vomp.task;

import com.zjty.fp.acq.vomp.subject.service.updater.VompFetcher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/11/27 14:28
 * <p>@author : C
 * 用于定义该子项目的定时任务
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Component
@Slf4j
public class VompTasks {
    /**
     * 采集工具类 将数据以文件形式保存
     */
    @Autowired
    VompFetcher vompFetcher;

    /**
     * 60分钟执行一次 采集
     */
    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 60)
    public void updateData() {
        vompFetcher.fetchData();
    }

}
