package com.zjty.fp.acq.misc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * fp-fp.
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-11-15 .
 */
public class CollectionUtil {

    @SafeVarargs
    public static <T, K extends Collection<T>> List<T> contact(K... datas) {
        return contact(Arrays.asList(datas));
    }

    public static <T, K extends Collection<T>> List<T> contact(Collection<K> datas) {
        List<T> result = new ArrayList<>();
        for (K k : datas) {
            result.addAll(k);
        }
        return result;
    }

    /**
     * 将一个list均分成n个list,主要通过偏移量来实现的
     *
     * @param source
     * @return
     */
    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        List<List<T>> result = new ArrayList<>();
        int remaider = source.size() % n;  //(先计算出余数)
        int number = source.size() / n;  //然后是商
        int offset = 0;//偏移量
        for (int i = 0; i < n; i++) {
            List<T> value;
            if (remaider > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                remaider--;
                offset++;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }
}
