package com.zjty.fp.acq.misc.utils;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * <p>Description : nsrsapi
 * <p>Date : 2018/9/13 16:58
 * <p>@author : Mcj
 */
public class DateUtil {

    /**
     * 以今日为基准,获得x天后的日期
     *
     * @param days 数字,代表几天后,参数可以是正数也可以是负数
     * @return 例:20181101
     */
    public static String getPlusDays(int days) {
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.plusDays(days);
        DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");
        return localDate.format(yyyyMMdd);
    }

    /**
     * 以今日为基准,获得x天后的日期精确到时分秒
     *
     * @param days 几天后或者几天前,参数可以是正数也可以是负数
     * @return Date类型
     * 例:2018-11-01 23:59:59
     */
    public static Date getPlusDaysMax(int days) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.plusDays(days);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.MAX);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    /**
     * 以今日为基准,获得x天后的日期精确到时分秒
     *
     * @param days 几天后或者几天前,参数可以是正数也可以是负数
     * @return Date类型
     * 例:2018-11-01 00:00:00
     */
    public static Date getPlusDaysMin(int days) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.plusDays(days);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

}
