package com.zjty.fp.acq.pssp.subject.controller;


import com.zjty.fp.acq.pssp.subject.service.AlertService;
import com.zjty.fp.acq.pssp.subject.service.RegionService;
import com.zjty.fp.acq.pssp.subject.service.WebsiteService;
import com.zjty.fp.acq.pssp.task.CollectDataTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author matrix
 */
@RestController
@RequestMapping("/pssp/test")
public class PsspTestController {


    @Autowired
    AlertService alertService;

    @Autowired
    WebsiteService websiteService;

    @Autowired
    RegionService regionService;

    @Autowired
    CollectDataTask psspTask;

    /**
     * 抓取所有报警数据(当前月)
     */
    @GetMapping("/alerts/all")
    public ResponseEntity<String> fetchAllAlerts() {
        alertService.fetchAllData();
        return ResponseEntity.ok("alerts fetch job is running success");
    }

    /**
     * 抓取更新的数据
     */
    @GetMapping("/alerts/updated")
    public ResponseEntity<String> fetchUpdatedAlerts() {
        alertService.fetchUpdatedData();
        return ResponseEntity.ok("update alerts data success");
    }

    /**
     * 抓取所有网页数据(当前月)
     */
    @GetMapping("/websites/all")
    public ResponseEntity<String> fetchAllWebsites(
            @RequestParam(value = "startTime") String startTime,
            @RequestParam(value = "endTime") String endTime) {
        //抓取指定月份的数据
        websiteService.fetchAllData();
        return ResponseEntity.ok("fetch websites success");
    }

    /**
     * 抓取更新的数据
     */
    @GetMapping("/websites/updated")
    public ResponseEntity<String> fetchUpdatedWebsites() {
        websiteService.fetchUpdatedData();
        return ResponseEntity.ok("update websites data success ");
    }

    /**
     * 抓取所有网页数据(当前月)
     */
    @GetMapping("/regions/all")
    public ResponseEntity<String> fetchAllRegions() {
        regionService.fetchAllData();
        return ResponseEntity.ok("fetch regions success");
    }

    /**
     * 抓取更新的数据
     */
    @GetMapping("/regions/updated")
    public ResponseEntity<String> fetchUpdatedRegions() {
        regionService.fetchUpdatedData();
        return ResponseEntity.ok("update regions data success ");
    }

}
