package com.zjty.fp.acq.pssp.subject.entity.location;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zjty.fp.acq.pssp.base.constant.DictConst;
import com.zjty.fp.acq.pssp.subject.entity.vo.PsspEvent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;


/**
 * @author matrix
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "pssp_alert")
public class Alert {

    /**
     * 分布式主键id
     */
    @Id
    @GeneratedValue
    @JsonPropertyOrder("1")
    private Long primaryId;


    /**
     * 源数据主键ID
     */
    @JsonPropertyOrder("2")
    private Long id;

    /**
     * 所属地区
     */
    @Column(name = "code_org")
    private Integer codeOrg;

    /**
     * 网站入口分类
     */
    @Column(name = "id_web_category")
    private Integer idWebCategory;

    /**
     * 网站入口信息
     */
    @Column(name = "id_web")
    private Integer idWeb;

    /**
     * 所匹配到的关键字
     */
    @Column(name = "match_keyword")
    private String matchKeyword;

    /**
     * 数据的标题
     */
    @Column(name = "title")
    private String title;

    /**
     * 数据摘要
     */
    @Column(name = "abstract")
    private String abs;

    /**
     * 源网页地址
     */
    @Column(name = "web_url")
    private String webUrl;

    /**
     * 本地预览（快照）地址
     */
    @Column(name = "web_snapshot")
    private String webSnapshot;

    /**
     * 源附件地址
     */
    @Column(name = "doc_url")
    private String docUrl;

    /**
     * 本地预览（快照）地址
     */
    @Column(name = "doc_snapshot")
    private String docSnapshot;

    /**
     * 数据抓取时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Column(name = "tm_fetch")
    private Date tmFetch;

    /**
     * 处理人ID
     */
    @Column(name = "handler_user")
    private Integer handlerUser;

    /**
     * 数据是否为压缩类型
     */
    @Column(name = "e_in_zip")
    private Integer eInZip;

    /**
     * 数据是否已读
     */
    @Column(name = "e_ident")
    private Integer eIdent;

    /**
     * 告警等级（红，黄，绿）
     */
    @Column(name = "e_alert")
    private Integer eAlert;


    /**
     * 数据类型
     */
    @Column(name = "e_type")
    private Integer eType;

    /**
     * 处理状态
     */
    @Column(name = "e_status")
    private Integer eStatus;

    public PsspEvent toEvent() {
        //从constMap中查询出web与region的名称
        String idWebName = DictConst.WEBSITE_MAP
                .getOrDefault(this.idWeb.longValue(), Website.defaultInstance())
                .getName();

        String regionName = DictConst.REGION_MAP
                .getOrDefault(String.valueOf(this.codeOrg), Region.defaultInstance())
                .getName();


        return new PsspEvent("pssp",
                tmFetch,
                String.valueOf(primaryId),
                id,
                codeOrg,
                regionName,
                idWebCategory,
                idWeb,
                idWebName,
                matchKeyword,
                title,
                abs,
                webUrl,
                webSnapshot,
                docUrl,
                docSnapshot,
                handlerUser,
                eInZip,
                eIdent,
                eAlert,
                eType,
                eStatus);
    }

}