package com.zjty.fp.acq.pssp.subject.entity.vo;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * PsspPageVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-26 at 10:57
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PsspPageVo {

    @JsonPropertyOrder("1")
    private int totalPage;

    @JsonPropertyOrder("4")
    private long totalElements;

    @JsonPropertyOrder("6")
    private int page;

    @JsonPropertyOrder("7")
    private int size;

    @JsonPropertyOrder("10")
    private boolean last;

    @JsonPropertyOrder("13")
    private List contents;

    public static PsspPageVo trans2PageVo(Page pageContent, int currentPage) {
        return new PsspPageVo(
                pageContent.getTotalPages(),
                pageContent.getTotalElements(),
                currentPage + 1,
                pageContent.getSize(),
                pageContent.isLast(),
                pageContent.getContent());
    }
}
