package com.zjty.fp.acq.pssp.subject.repository.remote;

import com.zjty.fp.acq.pssp.subject.entity.remote.RemoteWebsite;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * fusion-platform.
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-9-6 .
 */
@Repository
public interface RemoteWebsiteRepository extends JpaRepository<RemoteWebsite, Long>, JpaSpecificationExecutor<RemoteWebsite> {

    /**
     * 抓取指定id之后的源数据
     *
     * @param id 源网站数据主键id
     * @return 源网站数据集合
     */
    @Query("select o from RemoteWebsite o where o.id > ?1")
    List<RemoteWebsite> findDataFromId(Long id);
}
