package com.zjty.fp.acq.pssp.subject.service;

import com.zjty.fp.acq.pssp.subject.entity.location.Alert;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Date;
import java.util.List;

/**
 * 互联网门户平台服务接口
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 * @Date : 18-8-21
 */
public interface AlertService extends PsspTimeService<Alert> {

    /**
     * 根据主键id集合查询alert对象
     *
     * @param primaryIds 主键id集合
     * @return 报警集合
     */
    List<Alert> findAll(List<Long> primaryIds);

    /**
     * 查询指定分布式主键id之后的报警数据集合
     * @param primaryId 分布式主键ID
     * @return 报警集合
     */
    Page<Alert> findAllAfterId(Long primaryId, Pageable pageable);

    /**
     * 查询出报警数据的最早时间点.
     *
     * @return 最早的一条报警数据的时间
     */
    Date findEarliestTime();

}
