package com.zjty.fp.acq.union.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryLocation",
        transactionManagerRef = "transactionManagerLocation",
        basePackages = {
                "com.zjty.fp.acq.pssp.subject.repository.location",
                "com.zjty.fp.acq.vomp.subject.repository.local",
        }
)
@EnableConfigurationProperties(JpaProperties.class)
public class LocationConfig {
    @Autowired
    @Qualifier("locationDataSource")
    private DataSource locationDataSource;
    @Autowired
    private JpaProperties jpaProperties;

    @Bean(name = "entityManageLocation")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryLocation(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryLocation")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryLocation(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(locationDataSource)
                .properties(getVendorProperties(locationDataSource))
                .packages(
                        "com.zjty.fp.acq.pssp.subject.entity.location",
                        "com.zjty.fp.acq.vomp.subject.entity.localdo")
                .persistenceUnit("locationPersistenceUnit")
                .build();
    }

    private Map<String, String> getVendorProperties(DataSource dataSource) {
        return jpaProperties.getHibernateProperties(dataSource);
    }

    //    @Primary
    @Bean(name = "transactionManagerLocation")
    public PlatformTransactionManager transactionManagerLocation(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryLocation(builder).getObject());
    }
}

