package com.zjty.fp.acq.union.config;

import com.zjty.fp.acq.pssp.task.CollectDataTask;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.EmptyInterceptor;

/**
 * Sql 拦截器 用于替换alert表名
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-9-6 .
 */
@Slf4j
@SuppressWarnings("FieldCanBeLocal")
public class SqlInterceptor extends EmptyInterceptor {


    private String originalTableName = "remote.alert";


    @Override
    public String onPrepareStatement(String sql) {
        String prepareStatement = super.onPrepareStatement(sql);

        if (prepareStatement.contains(originalTableName)) {
            String tableMonth = CollectDataTask.getDynamicTableMonth();
            // replace指定月份 if trigger false 替换当前月
            String realTableName = "t_doc_" + tableMonth;
            log.info("[pssp]正在进行sql拦截 拦截的表为 {},替换后的表名为{}", "remote.alert", realTableName);
            prepareStatement = prepareStatement.replaceAll(originalTableName, realTableName);
        }
        return prepareStatement;
    }

}
