package com.zjty.fp.acq.vomp.subject.entity.localdo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;
import java.util.Random;

/**
 * @author C
 * 违规告警信息
 */
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "vomp_alarm")
public class VompAlarm {
    @Id
    private Integer recno;

    private String statId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date outBegin;

    private String unitName;

    private String deptment;
    /**
     * 处理人
     */
    private String tUser;
    /**
     * 主机名
     */
    private String hostName;
    /**
     * 转发
     */
    private String tReserve;
    /**
     * 操作系统
     */
    private String tos;

    private String tCard;

    private String macStr;

    private String ipStr;

    private String outIpstr;

    private String masterCode;

    private String hdCode;

    private String tVer;

    private String tMemo;

    private String tCompany;

    private String statStatus;

    private String zoneCode;

    private String unitType;

    @SuppressWarnings("unused")
    public static VompAlarm toSimc() {
        Random random = new Random();
        Integer recno = random.nextInt(8);
        String statId = Integer.valueOf(random.nextInt(1000)).toString();
        return new VompAlarm(
                recno,
                statId,
                new Date(),
                "杭州市测试",
                "杭州市测试",
                "测试人",
                "PGOS",
                "SZJC",
                "Win7",
                "[Marvell Yukon 88E8057 PCI-E Gigabit Ethernet Controller -数据包计划程序微型端口]",
                "F5 15 85 E6 37 44",
                "192.168.1.1",
                "20.1.1.1",
                "LENOVO To be filled by O.E.M SN:INVALID",
                "123456HD",
                "1.1.0",
                "经由⽹关[183.129.165.83]违规外联",
                "09",
                "未读",
                "330100",
                "3"
        );
    }
}
