package com.zjty.fp.acq.vomp.subject.service.api;

import com.zjty.fp.acq.misc.entity.UnionEvent;
import com.zjty.fp.acq.vomp.subject.entity.vo.VompEvent;
import com.zjty.fp.acq.vomp.subject.service.api.impl.VompEventServiceImpl;

import java.util.List;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/12/6 15:00
 * <p>@author : C
 * 对接前端告警页面的数据
 *
 * @see VompEventServiceImpl
 */
public interface VompEventService {

    /**
     * 按页查询
     *
     * @param page 页数
     * @param size 每页数量
     * @return UnionEvent集合
     */
    List<UnionEvent> findByPage(int page, int size);

    /**
     * 按id查询
     *
     * @param ids 用于查询的id集合
     * @return UnionEvent集合
     */
    List<UnionEvent> findByIds(List<Integer> ids);

    /**
     * 按id查询 返回类型不同于上个方法 是UnionEvent的子类
     *
     * @param ids 用于查询的id集合
     * @return VompEvent集合
     */
    List<VompEvent> findAllSubEvents(List<Integer> ids);

    /**
     * 所有告警的总数
     *
     * @return int
     */
    int totalCount();

    /**
     * 今日告警的总数
     *
     * @return int
     */
    int dailyCount();
}
