package com.zjty.fp.acq.vomp.subject.service.api.impl;

import com.zjty.fp.acq.vomp.subject.entity.localdo.*;
import com.zjty.fp.acq.vomp.subject.repository.local.*;
import com.zjty.fp.acq.vomp.subject.service.api.VompApiService;
import com.zjty.fp.acq.vomp.subject.service.api.VompJudgeHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Description : fp-fp
 * <p>Date : 2018/11/8 16:42
 * <p>@author : C
 * 该类提供查询 用于对网安提供API
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Service
public class VompApiServiceImpl implements VompApiService {
    @Autowired
    VompAlarmRepository vompAlarmRepository;
    @Autowired
    VompHandingInfoRepository vompHandingInfoRepository;
    @Autowired
    VompPcInfoRepository vompPcInfoRepository;
    @Autowired
    VompStatusRepository vompStatusRepository;
    @Autowired
    VompZoneRepository zoneRepository;
    @Autowired
    VompJudgeHelper judgeHelper;

    @Override
    public List<VompAlarm> getAlarmList() {
        return vompAlarmRepository.findAll().stream()
                .filter(judgeHelper::logicalExisted)
                .collect(Collectors.toList());
    }

    @Override
    public List<VompHandingInfo> getHandingInfoList() {
        return vompHandingInfoRepository.findAll();
    }

    @Override
    public List<VompPcInfo> getPcInfoList() {
        return vompPcInfoRepository.findAll();
    }

    @Override
    public List<VompStatus> getStatusList() {
        return vompStatusRepository.findAll();
    }

    @Override
    public List<VompZone> getZoneList() {
        return zoneRepository.findAll();
    }


}
