package com.zjty.fp.acq.vomp.subject.service.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zjty.fp.acq.vomp.subject.entity.remotedo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>Description : fp-fp
 * <p>Date : 2018/11/5 14:33
 * <p>@author : C
 * 缓存Vomp模块所有转换数据时需要用到的Map和List。
 */
@SuppressWarnings({"Duplicates", "SpringAutowiredFieldsWarningInspection"})
@Service
@Slf4j
public class VompTransCache {

    private List<ChkRoutes> chkRoutesList = Lists.newArrayList();

    private List<ChkStates> chkStatesList = Lists.newArrayList();

    private List<PcLog> pcLogList = Lists.newArrayList();

    private List<ServerStatus> serverStatusList = Lists.newArrayList();

    private List<Zone> zoneList = Lists.newArrayList();

    private Map<String, String> zoneId_ParentZoneId_Map = Maps.newHashMap();

    private Map<String, String> zoneId_ZoneName_Map = Maps.newHashMap();

    private List<ChkRoutes> getChkRoutesList() {
        return chkRoutesList;
    }

    /*
    缓存原始格式的数据
    */
    public void setChkRoutesList(List<ChkRoutes> chkRoutesList) {
        this.chkRoutesList = chkRoutesList;
    }

    private List<ChkStates> getChkStatesList() {
        return chkStatesList;
    }

    public void setChkStatesList(List<ChkStates> chkStatesList) {
        this.chkStatesList = chkStatesList;
    }

    private List<PcLog> getPcLogList() {
        return pcLogList;
    }

    public void setPcLogList(List<PcLog> pcLogList) {
        this.pcLogList = pcLogList;
    }

    public List<ServerStatus> getServerStatusList() {
        return serverStatusList;
    }

    public void setServerStatusList(List<ServerStatus> serverStatusList) {
        this.serverStatusList = serverStatusList;
    }

    public List<Zone> getZoneList() {
        return zoneList;
    }

    public void setZoneList(List<Zone> zoneList) {
        this.zoneList = zoneList;
    }

    public Map<String, String> getZoneId_ParentZoneId_Map() {
        return zoneId_ParentZoneId_Map;
    }

    public void setZoneId_ParentZoneId_Map(Map<String, String> zoneId_ParentZoneId_Map) {
        this.zoneId_ParentZoneId_Map = zoneId_ParentZoneId_Map;
    }

    public Map<String, String> getZoneId_ZoneName_Map() {
        return zoneId_ZoneName_Map;
    }

    public void setZoneId_ZoneName_Map(Map<String, String> zoneId_ZoneName_Map) {
        this.zoneId_ZoneName_Map = zoneId_ZoneName_Map;
    }

    /*
    根据原始数据对应关系生成Map
     */
    public Map<ChkStates, List<PcLog>> getChkStates_PcLog_Map() {
        Map<ChkStates, List<PcLog>> chkStates_PcLog_Map = Maps.newHashMap();
        List<ChkStates> chkStatesList = getChkStatesList();
        List<PcLog> pcLogList = getPcLogList();
        for (ChkStates chkStates : chkStatesList) {
            String mapNO = chkStates.getStatNo();
            List<PcLog> pcLogsInThisChkStates = Lists.newArrayList();
            for (PcLog pcLog : pcLogList) {
                if (pcLog.getChkNo().equals(mapNO)) {
                    pcLogsInThisChkStates.add(pcLog);
                }
            }
            chkStates_PcLog_Map.put(chkStates, pcLogsInThisChkStates);
        }
        return chkStates_PcLog_Map;
    }

    public Map<ChkStates, List<ChkRoutes>> getChkStates_ChkRoutes_Map() {
        Map<ChkStates, List<ChkRoutes>> ChkStates_ChkRoutes_Map = Maps.newHashMap();
        List<ChkStates> ChkStatesList = getChkStatesList();
        List<ChkRoutes> ChkRoutesList = getChkRoutesList();
        for (ChkStates ChkStates : ChkStatesList) {
            String mapNO = ChkStates.getStatNo();
            List<ChkRoutes> chkRoutsInThisChkStates = Lists.newArrayList();
            for (ChkRoutes ChkRoutes : ChkRoutesList) {
                if (ChkRoutes.getRoutNO().equals(mapNO)) {
                    chkRoutsInThisChkStates.add(ChkRoutes);
                }
            }
            ChkStates_ChkRoutes_Map.put(ChkStates, chkRoutsInThisChkStates);
        }
        return ChkStates_ChkRoutes_Map;
    }

    public Map<Zone, List<PcLog>> getZone_PcLog_Map() {
        Map<Zone, List<PcLog>> zone_PcLog_Map = Maps.newHashMap();
        List<Zone> zoneList = getZoneList();
        List<PcLog> pcLogList = getPcLogList();
        for (Zone zone : zoneList) {
            String zoneId = zone.getZoneId();
            List<PcLog> pcLogsInThisZone = Lists.newArrayList();
            for (PcLog PcLog : pcLogList) {
                if (PcLog.getZoneCode().equals(zoneId)) {
                    pcLogsInThisZone.add(PcLog);
                }
            }
            zone_PcLog_Map.put(zone, pcLogsInThisZone);
        }
        return zone_PcLog_Map;
    }

    public Map<String, String> getStatusMap() {
        Map<String, String> statusMap = Maps.newHashMap();
        statusMap.put("-1", "未知");
        statusMap.put("0", "未处理");
        statusMap.put("1", "处理完成");
        statusMap.put("2", "删除");
        statusMap.put("3", "测试");
        statusMap.put("10", "更改");
        statusMap.put("100", "关注");
        statusMap.put("110", "电话核查");
        statusMap.put("115", "现场核查");
        statusMap.put("120", "主要案情");
        statusMap.put("180", "处理措施及整改情况");
        return statusMap;
    }

}
