package com.zjty.fp.acq.vomp.subject.service.updater.impl;

import com.google.common.collect.Lists;
import com.zjty.fp.acq.vomp.subject.entity.localdo.*;
import com.zjty.fp.acq.vomp.subject.entity.remotedo.*;
import com.zjty.fp.acq.vomp.subject.repository.local.*;
import com.zjty.fp.acq.vomp.subject.repository.remote.*;
import com.zjty.fp.acq.vomp.subject.service.api.VompTransHelper;
import com.zjty.fp.acq.vomp.subject.service.cache.VompTransCache;
import com.zjty.fp.acq.vomp.subject.service.updater.VompUpdater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2019/1/2 11:24
 * <p>@author : C
 * Db意为Database。该组件的同步数据模式为直接从目标数据库读取数据并保存到自己的数据库。
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Service
@Slf4j
public class VompDataDbUpdater implements VompUpdater {
    @Autowired
    VompTransCache transCache;
    @Autowired
    VompTransHelper transHelper;
    @Autowired
    ChkRoutesRepository chkRoutesRepository;
    @Autowired
    ChkStatesRepository chkStatesRepository;
    @Autowired
    PcLogRepository pcLogRepository;
    @Autowired
    ServerStatusRepository serverStatusRepository;
    @Autowired
    ZoneRepository zoneRepository;

    @Autowired
    VompAlarmRepository vompAlarmRepository;
    @Autowired
    VompHandingInfoRepository vompHandingInfoRepository;
    @Autowired
    VompPcInfoRepository vompPcInfoRepository;
    @Autowired
    VompStatusRepository vompStatusRepository;
    @Autowired
    VompZoneRepository vompZoneRepository;

    @Override
    public void updateData() {
        //fetch data from remote database and save cache
        fetchRemoteDataAndSaveCache();
        //get data from cache and trans and save to local database
        updateAllData();
    }

    private void fetchRemoteDataAndSaveCache() {
        //chkroutes
        List<ChkRoutes> chkRoutesList = chkRoutesRepository.findAll();
        transCache.setChkRoutesList(chkRoutesList);
        //chkroutes
        List<ChkStates> chkStatesList = chkStatesRepository.findAll();
        transCache.setChkStatesList(chkStatesList);
        //pclog
        List<PcLog> pcLogList = pcLogRepository.findAll();
        transCache.setPcLogList(pcLogList);
        //chkroutes
        List<ServerStatus> serverStatusList = serverStatusRepository.findAll();
        transCache.setServerStatusList(serverStatusList);
        //chkroutes
        List<Zone> zoneList = zoneRepository.findAll();
        transCache.setZoneList(zoneList);
    }


    /**
     * Local Data
     */
    private void updateAllData() {
        updateVompAlarmDb();
        updateVompHandingInfoDb();
        updateVompPcInfoDb();
        updateVompStatusDb();
        updateZoneDb();
    }

    private void updateVompAlarmDb() {
        List<VompAlarm> alarmList4Save = getAlarmList();
        vompAlarmRepository.save(alarmList4Save);
        log.info("[vomp] VompAlarm更新了{}条数据", alarmList4Save.size());
    }

    private void updateVompHandingInfoDb() {
        List<VompHandingInfo> handingInfoList4Save = getHandingInfoList();
        vompHandingInfoRepository.save(handingInfoList4Save);
        log.info("[vomp] VompHandingInfo更新了{}条数据", handingInfoList4Save.size());
    }

    private void updateVompPcInfoDb() {
        List<VompPcInfo> pcInfoList4Save = getPcInfoList();
        vompPcInfoRepository.save(pcInfoList4Save);
        log.info("[vomp] VompPcInfo更新了{}条数据", pcInfoList4Save.size());
    }

    private void updateVompStatusDb() {
        List<VompStatus> statusList4Save = getStatusList();
        vompStatusRepository.save(statusList4Save);
        log.info("[vomp] VompStatus更新了{}条数据", statusList4Save.size());
    }

    private void updateZoneDb() {
        List<VompZone> zoneList4Save = getZoneList();
        vompZoneRepository.save(zoneList4Save);
        log.info("[vomp] VompZone更新了{}条数据", zoneList4Save.size());
    }

    /**
     * VompAlarm
     */
    private List<VompAlarm> getAlarmList() {
        List<VompAlarm> vompAlarmList = Lists.newArrayList();
        transCache.getChkStates_PcLog_Map().forEach((chkstates, pcLogs) -> pcLogs.forEach(pclog -> vompAlarmList.add(transHelper.transToVompAlarm(chkstates, pclog))));
        return vompAlarmList;
    }

    /**
     * VompHandingInfo
     */
    private List<VompHandingInfo> getHandingInfoList() {
        List<VompHandingInfo> vompHandingInfoList = Lists.newArrayList();
        transCache.getChkStates_ChkRoutes_Map().forEach((chkstates, chkRoutes) -> chkRoutes.forEach(chkRoute -> vompHandingInfoList.add(transHelper.transToHandingInfo(chkstates, chkRoute))));
        return vompHandingInfoList;
    }

    /**
     * VompPcInfo
     */
    private List<VompPcInfo> getPcInfoList() {
        List<VompPcInfo> vompPcInfoList = Lists.newArrayList();
        transCache.getZone_PcLog_Map().forEach((zone, pcLogList) -> vompPcInfoList.add(transHelper.transToVompPcInfoVo(zone, pcLogList)));
        return vompPcInfoList;
    }

    /**
     * Status
     */
    private List<VompStatus> getStatusList() {
        return transCache.getServerStatusList().stream()
                .map(transHelper::transToStatus)
                .collect(Collectors.toList());
    }

    /**
     * VompZone
     */
    private List<VompZone> getZoneList() {
        return transCache.getZoneList().stream()
                .map(transHelper::transToVompZone)
                .map(transHelper::addParentZoneName)
                .map(transHelper::addGrandParentZoneName)
                .collect(Collectors.toList());
    }

}
