package com.zjty.fp.acq.vomp.subject.service.updater.impl;

import com.zjty.fp.acq.vomp.subject.entity.localdo.VompZone;
import com.zjty.fp.acq.vomp.subject.repository.local.VompZoneRepository;
import com.zjty.fp.acq.vomp.subject.service.cache.VompTransCache;
import com.zjty.fp.acq.vomp.subject.service.updater.VompUpdater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/12/28 15:27
 * <p>@author : C
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Slf4j
@Service
public class VompMapUpdater implements VompUpdater {
    @Autowired
    VompZoneRepository zoneRepository;
    @Autowired
    VompTransCache transCache;

    @Override
    public void updateData() {
        transCache.setZoneId_ParentZoneId_Map(createZoneIdToParentZoneIdMap());
        transCache.setZoneId_ZoneName_Map(createZoneIdToZoneNameMap());
        log.info("[vomp] 更新了数据映射关系Map");
    }


    private Map<String, String> createZoneIdToParentZoneIdMap() {
        return zoneRepository.findAll().stream().collect(Collectors.toMap(VompZone::getZoneId, VompZone::getParentId));
    }

    private Map<String, String> createZoneIdToZoneNameMap() {
        return zoneRepository.findAll().stream().collect(Collectors.toMap(VompZone::getZoneId, VompZone::getZoneName));
    }
}
