package com.zjty.fp.acq.vomp.task;

import com.zjty.fp.acq.vomp.subject.service.updater.impl.VompDataDbUpdater;
import com.zjty.fp.acq.vomp.subject.service.updater.impl.VompDataRdUpdater;
import com.zjty.fp.acq.vomp.subject.service.updater.impl.VompFetcherImpl;
import com.zjty.fp.acq.vomp.subject.service.updater.impl.VompMapUpdater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/11/27 14:28
 * <p>@author : C
 * 用于定义该子项目的定时任务
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Component
@Slf4j
public class VompTasks {
    @Autowired
    VompFetcherImpl vompFetcher;
    @Autowired
    VompDataRdUpdater dataUpdater;
    @Autowired
    VompMapUpdater mapUpdater;


    /**
     * 60分钟执行一次 采集
     */
    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 60)
    public void fetchData() {
        vompFetcher.fetchData();
    }


    /**
     * 60分钟执行一次 读取
     */
//    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 60)
    public void updateData() {
        dataUpdater.updateData();
        mapUpdater.updateData();
    }

    /**
     * 3分钟执行一次
     */
    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 3)
    public void updateRedisData() {
        log.info("[vomp] 开始更新缓存数据");
        mapUpdater.updateData();
        log.info("[vomp] 更新缓存数据完毕");
    }
}
