package com.zjty.fp.acq.pssp.base.aspect;

import com.zjty.fp.acq.pssp.task.CollectDataTask;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * fusion-platform.
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 19-1-24 .
 */
@Component
@Aspect
@Slf4j
public class PsspScheduleTrigger {

    /**
     * 设自定义注解@ThreemLoginValidation为AOP切点
     */
    @Pointcut("@annotation(com.zjty.fp.acq.pssp.base.aspect.EnablePsspSchProtect)")
    public void schTriggerPointCut() {
    }

    /**
     * 在标有@ThreemLoginValidation注解的方法之前执行的逻辑
     */
    @Around("schTriggerPointCut()")
    public Object aroundSchTrigger(ProceedingJoinPoint joinPoint) throws Throwable {

        if (!CollectDataTask.trigger) {
            log.info("[pssp] 检测到定时任务开关状态为关闭状态,本次{}类执行的任务结束", joinPoint.getSignature().getName());
            return null;
        } else {
            CollectDataTask.trigger = false;
            Object proceed = joinPoint.proceed();
            CollectDataTask.trigger = true;
            return proceed;
        }

    }
}
