package com.zjty.fp.acq.pssp.subject.entity.location;

import lombok.*;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * <pre>
 *  {
 *      "id":"唯一标识符，四位整数",
 *      "entry":"网站入口，网址"
 *      "name":"网站名称",
 *      "scope":"抓取范围,是一个网址",
 *      "unit":"网站使用单位名称",
 *      "code_org":"所属地区的code，取值为四位整数,参见下表t_dic_org",
 *      "id_web_category":"网站入口分类，取值为 4:政府  5：高校  6：军工 7：金融  8：其他",
 *      "level_":"重要性， 3：高 2：中  1：低",
 *      "status_approve":"审批状态，取值为 待定:0，未通过:-1  通过：1"
 *      "status_web":"网站状态， -2：访问失败  -1：网址格式异常 0：未确认 1：有效"
 *      "status_collect":"采集状态，0：启用  1：禁用 2：自定义"
 * }
 * </pre>
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 * @since : 18-9-3
 */
@Data
@Entity
@NoArgsConstructor
@Table(name = "pssp_website")
public class Website {

    @Id
    @GenericGenerator(name = "myGen", strategy = "assigned")
    @GeneratedValue(generator = "myGen")
    private Long id;
    private String entry;
    private String name;
    private String scope;
    private String unit;
    private Integer codeOrg;
    private Integer idWebCategory;
    private Integer level;
    private Integer statusApprove;
    private Integer statusWeb;
    private Integer statusCollect;

    /**
     * 该属性用于提供默认为空值的网站对象
     */
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    @Transient
    private static Website defaultWebsite = new Website(
            99999L,
            "www.example.com",
            "默认示例网站",
            "example.com",
            "示例单位名称",
            99999,
            8,
            1,
            1,
            0,
            1);

    public Website(Long id,String entry, String name, String scope, String unit, Integer codeOrg, Integer idWebCategory, Integer level, Integer statusApprove, Integer statusWeb, Integer statusCollect) {
        this.id = id;
        this.entry = entry;
        this.name = name;
        this.scope = scope;
        this.unit = unit;
        this.codeOrg = codeOrg;
        this.idWebCategory = idWebCategory;
        this.level = level;
        this.statusApprove = statusApprove;
        this.statusWeb = statusWeb;
        this.statusCollect = statusCollect;
    }

    public static Website defaultInstance() {
        return defaultWebsite;
    }
}
