package com.zjty.fp.acq.misc.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Slf4j
@Scope("prototype")
@Component
public class FileCreator {
    public File createFile(String subName, String catalog, String data) {
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDate(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, data.getBytes());
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFileNoTime(String subName, String catalog, String data) {
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = subName + "-" + catalog +  ".txt";
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path, data.getBytes());
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFileInUTF(String subName, String catalog,Long index, List<String> list){
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = subName + "-" + catalog + "-" +index+".txt";
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path,list);
            } catch (IOException e) {
                log.info("生成文件时出现异常：{}" + e);
            }
        }
        return new File(pathname + filename);
    }

    public File createFile(String subName, String catalog, List<String> list) {
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDate(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                Files.write(path,list);
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }
    public File createFileStms(String subName, String catalog, List<String> list){
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDateStms(subName, catalog);
        String fileNameTmp=getFileNameByDateStmsTmp(subName, catalog);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                File file= File.createTempFile(filename,".tmp",new File(pathname));
                Files.write(path,list);
                new File(pathname + filename).renameTo(new File(pathname+fileNameTmp));
                file.delete();
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }
    public File createFileStms(String subName, String catalog, List<String> list,int count){
        String pathname = "files/" + subName + "/" + catalog + "/";
        String filename = getFileNameByDateStms(subName, catalog,count);
        String fileNameTmp=getFileNameByDateStmsTmp(subName, catalog,count);
        Path path = Paths.get(pathname + filename);
        boolean make = createFilePath(new File(pathname));
        if (make) {
            try {
                File file= File.createTempFile(filename,".tmp",new File(pathname));
                Files.write(path,list);
                new File(pathname + filename).renameTo(new File(pathname+fileNameTmp));
                file.delete();
            } catch (IOException e) {
                log.info("生成文件时出现异常：" + e.getMessage());
            }
        }
        return new File(pathname + filename);
    }
    /**
     * 根据日期生成文件名
     * 以天为单位
     * 文件名格式：平台名-种类-时间（yyyyMMdd）.txt
     */
    private String getFileNameByDate(String subName, String catalog) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return subName + "-" + catalog + "-" + sdf.format(new Date()) + ".txt";
    }

    private String getFileNameByDateStms(String subName, String catalog,int count) {
        return subName + "-" + catalog + count+".tmp";
    }

    private String getFileNameByDateStmsTmp(String subName, String catalog,int count) {
        return subName + "-" + catalog + count +".txt";
    }

    private String getFileNameByDateStms(String subName, String catalog) {
        return subName + "-" + catalog +".tmp";
    }

    private String getFileNameByDateStmsTmp(String subName, String catalog) {
        return subName + "-" + catalog  +".txt";
    }

    /**
     * 生成指定的文件夹路径
     * 若文件夹不存在则创建
     */
    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }

}
