package com.zjty.fp.acq.pssp.subject.entity.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * pssp平台首页相关数据
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-11-7 .
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "pssp首页数据模型", description = "里面包含了pssp平台的累计数据与今日报警数据")
public class PsspIndex {


    @ApiModelProperty(value = "pssp平台的累计报警数", example = "10086")
    private long cumulative;

    @JsonProperty("today")
    @ApiModelProperty(value = "pssp平台今日报警数据模型")
    private TodayData today;

}

