package com.zjty.fp.acq.vomp.subject.service.api.impl;

import com.zjty.fp.acq.vomp.subject.entity.vo.VompFpVo;
import com.zjty.fp.acq.vomp.subject.repository.local.VompAlarmRepository;
import com.zjty.fp.acq.vomp.subject.repository.local.VompPcInfoRepository;
import com.zjty.fp.acq.vomp.subject.service.api.VompFpService;
import com.zjty.fp.acq.vomp.subject.service.api.VompJudgeHelper;
import com.zjty.fp.acq.vomp.subject.service.api.VompTransHelper;
import com.zjty.fp.acq.vomp.subject.service.cache.VompTransCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.stream.Collectors;

/**
 * <p>Description : fp-extr
 * <p>Date : 2018/10/30 14:48
 * <p>@author : C
 * 对前端首页提供数据:提供本市（杭州）监控终端数量、本年度总报警率、本年度总报警数。
 * 返回数据：
 *
 * @see VompFpVo
 */
@SuppressWarnings({"SpringAutowiredFieldsWarningInspection", "Duplicates"})
@Slf4j
@Service
public class VompFpServiceImpl implements VompFpService {
    @Autowired
    VompAlarmRepository alarmRepository;
    @Autowired
    VompPcInfoRepository pcInfoRepository;
    @Autowired
    VompTransCache transCache;
    @Autowired
    VompTransHelper transHelper;
    @Autowired
    VompJudgeHelper judgeHelper;

    /**
     * @return 前端首页数据包装对象
     */
    @Override
    public VompFpVo getVompFpVo() {
        return new VompFpVo(
                getPcCountInHangZhou(),
                getTotalAlarmCountInHangZhouInCurrentYear(),
                getAlarmRateInHangZhouInCurrentYear()
        );
    }

    /*
    Private Methods
     */

    /**
     * 杭州市本年度总报警率
     *
     * @return String
     */
    private String getAlarmRateInHangZhouInCurrentYear() {
        Integer alarmCount = getTotalAlarmCountInHangZhouInCurrentYear();
        Integer pcCount = getPcCountInHangZhou();
        DecimalFormat df = new DecimalFormat("#0.00");
        log.info("[vomp] 开始计算报警率:报警数为【{}】，监控终端数量为【{}】", alarmCount, pcCount);
        Double totalAlarmRate = Double.valueOf(alarmCount) / Double.valueOf(pcCount);
        Double zero = 0.;
        if (Double.valueOf(pcCount).equals(zero)) {
            return "-1";
        }
        return df.format(totalAlarmRate);
    }

    /**
     * 杭州市本年度报警数
     */
    private Integer getTotalAlarmCountInHangZhouInCurrentYear() {
        return alarmRepository.findAll().stream()
                .filter(judgeHelper::logicalExisted)
                .filter(judgeHelper::isInHangzhou)
                .filter(judgeHelper::isInCurrentYear)
                .collect(Collectors.toList())
                .size();
    }

    /**
     * 杭州市全市监控终端数量
     */
    private Integer getPcCountInHangZhou() {
        return pcInfoRepository.findAll().stream()
                .filter(judgeHelper::isInHangzhou)
                .mapToInt(transHelper::getPcCount)
                .sum();
    }

}
