## ES对接各平台说明



### 搜索功能：

注入：utils.esutil.search.EsSearch

esSearchData()方法，具体传入参数如下：



```java
搜索方法：
/**
     * 获取es搜索的原数据
     * @param modules       平台名 String
     *                      pssp
     *                      nsrs
     *                      ndss
     *                      vomp
     *                      stms              
     *                      ### 多个平台搜索用 , 分割　
     * @param mac           搜索mac String
     * @param ip            搜索ip,String
     * @param key           搜索关键词,Stringl
     * @param startTime     开始时间 long类型 精确到毫秒,13位
     * @param endTime       结束时间 long类型
     * @param page          分页,第几页,0开始
     * @param size          分页,每页大小
     * @return
     */
     
     
    @Autowired
    private EsSearch esSearch;
    //创建es搜索对象
    EsSearchArg esSearchArg = new EsSearchArg.Builder().modules("pssp,ndss")
    				 .ip("10.10.10.10")
    				 .mac("qa ws ed rf")
    				 .key("杭州")
    				 .startTime(10000000L)
    				 .endTime(2000000L)
    				 .page(0)
    				 .size(20)
    				 .build();
	//调用esSearchArg方法，传入搜索对象
    EsSearchRs esSearchRs = esSearch.esSearchData(esSearchArg);

```

EsSearchRs 返回值示例

```json

{
  "total": 100L,
  "ndss": [
    "9e9c68ceafb343709ec954e2eb5b4dda",
    "09575120a34e4ec9b248184d9580ce25",
    "e288ad05e8d34be7828cf9a942c8001a",
    "1200a561551345c3972c1d8abb9e20b7"
  ],
  "nsrs": [
    "113531"
  ]，
  "stmsAv": [
      "1",
      "2",
      "3"
  ]，
  "stmsTcp": [
      "1",
      "2",
      "3"
  ]
}
```







### ES各平台将数据写入ES的方法（新增和修改方法相同）

说明：在新增的数据中执行一次ES新增数据方法。

注入utils.esUtil.update.Es{Vomp}

###花括号中的为各自的平台名，调用方法update{Vomp}Data(List<EsVompData> list)

###传入对象在utils.esUtil.entity中有各个平台的对象，字段与各平台对应，有个别字段不同。

###个别字段说明　

A. ip1,ip2,ip3,mac1,mac2,mac3 将自己平台是ip或者mac的放入ip1,ip2,mac1,mac2，顺序不重要

B. 时间字段为tmFetch

C.　Pssp平台中　abstract　对应　abstractInfo

示例

```java
@Autowired
private EsNdss esNdss;

@Test
    public void ndss() {
         List<EsNdssData> list = new ArrayList<>();
		
        // 将对象进行转换　List<NdssData> ndsslit => List<EsNdssData> list
       
        esNdss.updateNdssData(list);
    }
```



各平台查询数据是否写入es成功方法：

curl -XGET http://192.168.1.158:9200/fp_alarm_vomp/_search

curl -XGET http://192.168.1.158:9200/fp_alarm_pssp/_search

curl -XGET http://192.168.1.158:9200/fp_alarm_nsrs/_search

curl -XGET http://192.168.1.158:9200/fp_alarm_ndss/_search

curl -XGET http://192.168.1.158:9200/fp_alarm_stms_tcp/_search



STMS平台索引如下：

fp_alarm_stms_av

fp_alarm_stms_blackdns

fp_alarm_stms_blackip

fp_alarm_stms_blackhttp

fp_alarm_stms_info

fp_alarm_stms_mail

fp_alarm_stms_tcp

fp_alarm_stms_trojanwall

fp_alarm_stms_protohttp



示例：

```bash
ljj@ljj-ThinkPad-T440s:~$ curl -XGET http://192.168.1.158:9200/fp_alarm_vomp/_search?pretty
{
  "took" : 2,
  "timed_out" : false,
  "_shards" : {
    "total" : 5,
    "successful" : 5,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : 1,　//数据数量
    "max_score" : 1.0,
    "hits" : [	//数据详情
      {
        "_index" : "fp_alarm_vomp",
        "_type" : "doc",
        "_id" : "123",
        "_score" : 1.0,
        "_source" : {
          "id" : "123",
          "type" : "vomp",
          "rout_status" : "null",
          "zone" : "null",
          "unit_name" : "null",
          "deptment" : "null",
          "tuse" : "null",
          "host_name" : "null",
          "tos" : "null",
          "tmemo" : "null",
          "mac1" : "null",
          "ip1" : "null",
          "ip2" : "null",
          "tm_fetch" : 1510023459000
        }
      }
    ]
  }
}

```





### 各平台获取ES主键id集合的方法

```java
＠AutoWired
private EsSearch esSearch;

public void test() {

	//自定义时间范围　13位long　
	Long startTime;
	Long endTime;
    
	//获取es中自定义时间段范围内的总数数量
	//第一个参数　ndss pssp nsrs vomp stms
    int total = esSearch.esSearchTotal("ndss",startTime,endTime);
    //获取es中的数据　list，不同平台泛型不同
    List<String> esList = esSearch.esSearchIdByTimeNdss(total,startTime,endTime);
  	//根据自己需求比对list，将有差异的数据存入es
    
}
```

