package com.zjty.fp.api.misc.utils;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * <p>Description : vompin
 * <p>Date : 2018/9/29 15:44
 * <p>@author : Matrix [xhyrzldf@foxmail.com]
 */
@SuppressWarnings({"unused", "UnusedReturnValue"})
@Component
@Scope("prototype")
@Slf4j
public class FileReader {


    public List<String> readFileData(String subName, String catalog) {
        List<String> data = Lists.newArrayList();
        String localFilePath = "file/" + subName + "/" + catalog + "/";
        String fileName = getFileNameByDate(subName, catalog);
        File file = new File(localFilePath + fileName);
        Path path = Paths.get(localFilePath + fileName);
        try {
            data = Files.readAllLines(path);
        } catch (IOException e) {
            log.info("读取文件时出现异常：" + e);
        }
        return data;
    }

    /**
     * 根据日期生成文件名
     * 以天为单位
     * 文件名格式：平台名-种类-时间（yyyyMMdd）.txt
     */
    private String getFileNameByDate(String subName, String catalog) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return subName + "-" + catalog + "-" + sdf.format(new Date()) + ".txt";
    }

    /**
     * 生成指定的文件夹路径
     * 若文件夹不存在则创建
     */
    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }
}
