package com.zjty.fp.api.pssp.subject.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.annotation.ExcelIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zjty.fp.api.misc.entity.UnionEvent;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

import javax.persistence.Column;
import java.util.Date;

/**
 * fp-api.
 *
 * @author : Matrix [xhyrzldf@gmail.com]
 * 18-11-12 .
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class PsspEvent extends UnionEvent {

    @JsonPropertyOrder("1")
    @Excel(name = "系统分布式id", orderNum = "1", width = 20)
    private String primaryId;

    /**
     * 源数据主键ID
     */
    @JsonPropertyOrder("2")
    @ExcelIgnore
    private Long id;

    /**
     * 所属地区
     */
    @JsonPropertyOrder("4")
    @Excel(name = "地区编码", orderNum = "3")
    private Integer codeOrg;

    /**
     * 所属地区名称
     */
    @JsonPropertyOrder("6")
    @Excel(name = "地区名称", orderNum = "4")
    private String regionName;

    /**
     * 网站入口分类
     */
    @JsonPropertyOrder("8")
    @Excel(name = "网站入口分类", width = 13, orderNum = "6", replace = {"政府_4", "高校_5", "军工_6", "金融_7", "其他_8"})
    private Integer idWebCategory;

    /**
     * 网站入口信息
     */
    @JsonPropertyOrder("10")
    @Excel(name = "网站入口信息", width = 13, orderNum = "8")
    private Integer idWeb;


    @JsonPropertyOrder("11")
    @Excel(name = "网站入口名称", width = 13, orderNum = "9")
    private String idWebName;

    /**
     * 所匹配到的关键字
     */
    @JsonPropertyOrder("12")
    @Excel(name = "命中关键字", width = 13, orderNum = "10")
    private String matchKeyword;

    /**
     * 数据的标题
     */
    @JsonPropertyOrder("14")
    @Excel(name = "数据标题", orderNum = "12", width = 20, height = 25)
    private String title;

    /**
     * 数据摘要
     */
    @JsonPropertyOrder("16")
    @Excel(name = "数据摘要", orderNum = "14", width = 40, height = 25)
    private String abs;

    /**
     * 源网页地址
     */
    @JsonPropertyOrder("18")
    @Excel(name = "源网站地址", orderNum = "16", width = 35, height = 25)
    private String webUrl;

    /**
     * 本地预览（快照）地址
     */
    @JsonPropertyOrder("20")
    @Excel(name = "本地预览web(快照)地址", orderNum = "18", width = 35, height = 25)
    private String webSnapshot;

    /**
     * 源附件地址
     */
    @JsonPropertyOrder("22")
    @Excel(name = "源附件地址", orderNum = "20", width = 35, height = 25)
    private String docUrl;

    /**
     * 本地预览（快照）地址
     */
    @JsonPropertyOrder("24")
    @Excel(name = "本地预览附件(快照)地址", orderNum = "22", width = 35, height = 25)
    private String docSnapshot;

    /**
     * 处理人ID
     */
    @JsonPropertyOrder("26")
    @Excel(name = "处理人id", orderNum = "24")
    private Integer handlerUser;

    /**
     * 数据是否为压缩类型
     */
    @JsonPropertyOrder("28")
    @Excel(name = "是否为压缩包", replace = {"是_1", "否_2"}, orderNum = "26")
    private Integer eInZip;

    /**
     * 数据是否已读
     */
    @JsonPropertyOrder("30")
    @Column(name = "e_ident")
    @Excel(name = "是否已读", orderNum = "28", replace = {"否_0", "是_1"})
    private Integer eIdent;

    /**
     * 告警等级（红，黄，绿）
     */
    @JsonPropertyOrder("32")
    @Excel(name = "告警等级", orderNum = "30", replace = {"绿_1", "黄_2", "红_3"})
    private Integer eAlert;

    /**
     * 数据类型
     */
    @JsonPropertyOrder("34")
    @Excel(name = "数据类型", orderNum = "32", replace = {"未知_0", "网页_1", "图片_2", "文档_3", "压缩包_4", "多媒体_5"})
    private Integer eType;

    /**
     * 处理状态
     */
    @JsonPropertyOrder("36")
    @Excel(name = "处理状态", orderNum = "32", replace = {"未处理_0", "正常_10", "疑似_20", "泄密_30"})
    private Integer eStatus;

    public PsspEvent(
            String platform,
            Date tmFetch,
            String primaryId,
            Long id,
            Integer codeOrg,
            String regionName,
            Integer idWebCategory,
            Integer idWeb,
            String idWebName,
            String matchKeyword,
            String title,
            String abs,
            String webUrl,
            String webSnapshot,
            String docUrl,
            String docSnapshot,
            Integer handlerUser,
            Integer eInZip,
            Integer eIdent,
            Integer eAlert,
            Integer eType,
            Integer eStatus) {

        super(platform, tmFetch);
        this.primaryId = primaryId;
        this.id = id;
        this.codeOrg = codeOrg;
        this.regionName = regionName;
        this.idWebCategory = idWebCategory;
        this.idWeb = idWeb;
        this.idWebName = idWebName;
        this.matchKeyword = matchKeyword;
        this.title = title;
        this.abs = abs;
        this.webUrl = webUrl;
        this.webSnapshot = webSnapshot;
        this.docUrl = docUrl;
        this.docSnapshot = docSnapshot;
        this.handlerUser = handlerUser;
        this.eInZip = eInZip;
        this.eIdent = eIdent;
        this.eAlert = eAlert;
        this.eType = eType;
        this.eStatus = eStatus;
    }



    public String getPrimaryId() {
        return primaryId;
    }

    public void setPrimaryId(String primaryId) {
        this.primaryId = primaryId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCodeOrg() {
        return codeOrg;
    }

    public void setCodeOrg(Integer codeOrg) {
        this.codeOrg = codeOrg;
    }

    public Integer getIdWebCategory() {
        return idWebCategory;
    }

    public void setIdWebCategory(Integer idWebCategory) {
        this.idWebCategory = idWebCategory;
    }

    public Integer getIdWeb() {
        return idWeb;
    }

    public void setIdWeb(Integer idWeb) {
        this.idWeb = idWeb;
    }

    public String getMatchKeyword() {
        return matchKeyword;
    }

    public void setMatchKeyword(String matchKeyword) {
        this.matchKeyword = matchKeyword;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbs() {
        return abs;
    }

    public void setAbs(String abs) {
        this.abs = abs;
    }

    public String getWebUrl() {
        return webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getWebSnapshot() {
        return webSnapshot;
    }

    public void setWebSnapshot(String webSnapshot) {
        this.webSnapshot = webSnapshot;
    }

    public String getDocUrl() {
        return docUrl;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    public String getDocSnapshot() {
        return docSnapshot;
    }

    public void setDocSnapshot(String docSnapshot) {
        this.docSnapshot = docSnapshot;
    }

    public Integer getHandlerUser() {
        return handlerUser;
    }

    public void setHandlerUser(Integer handlerUser) {
        this.handlerUser = handlerUser;
    }

    public Integer geteInZip() {
        return eInZip;
    }

    public void seteInZip(Integer eInZip) {
        this.eInZip = eInZip;
    }

    public Integer geteIdent() {
        return eIdent;
    }

    public void seteIdent(Integer eIdent) {
        this.eIdent = eIdent;
    }

    public Integer geteAlert() {
        return eAlert;
    }

    public void seteAlert(Integer eAlert) {
        this.eAlert = eAlert;
    }

    public Integer geteType() {
        return eType;
    }

    public void seteType(Integer eType) {
        this.eType = eType;
    }

    public Integer geteStatus() {
        return eStatus;
    }

    public void seteStatus(Integer eStatus) {
        this.eStatus = eStatus;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getIdWebName() {
        return idWebName;
    }

    public void setIdWebName(String idWebName) {
        this.idWebName = idWebName;
    }
}
