package com.zjty.fp.api.pssp.subject.repository.remote;

import com.zjty.fp.api.pssp.subject.entity.remote.RemoteAlert;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @author matrix
 */
@Repository
public interface RemoteAlertRepository extends JpaRepository<RemoteAlert, Long>,
        JpaSpecificationExecutor<RemoteAlert> {

    /**
     * 抓取指定时间之后的源数据
     *
     * @param time 指定的时间
     * @return 源报警数据集合
     */
    @Query("select o from RemoteAlert o where o.tmFetch > ?1")
    List<RemoteAlert> findDataFromTime(Date time);

    /**
     * 抓取指定id之后的源数据
     *
     * @param id 源数据的主键id
     * @return 源报警数据集合
     */
    @Query("select o from RemoteAlert o where o.id > ?1")
    List<RemoteAlert> findDataFromId(Long id);

}
