package com.zjty.fp.api.union.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.Map;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2019/1/3 14:33
 * <p>@author : C
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryRemote2",
        transactionManagerRef = "transactionManagerRemote2",
        basePackages = {"com.zjty.fp.api.vomp.subject.repository.remote"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class Remote2Config {

    @Autowired
    @Qualifier("remoteDataSource2")
    private DataSource remoteDataSource2;
    @Autowired
    private JpaProperties jpaProperties;

    @Bean(name = "entityManageRemote2")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryRemote(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryRemote2")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryRemote(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource2)
                .properties(getVendorProperties(remoteDataSource2))
                .packages("com.zjty.fp.api.vomp.subject.entity.remotedo")
                .persistenceUnit("remotePersistenceUnit2")
                .build();
    }

    private Map<String, String> getVendorProperties(DataSource dataSource) {
        return jpaProperties.getHibernateProperties(dataSource);
    }

    @Bean(name = "transactionManagerRemote2")
    public PlatformTransactionManager transactionManagerRemote(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryRemote(builder).getObject());
    }
}
