package com.zjty.fp.api.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;


/**
 * @author C
 * 报警记录
 * 一个报警表单中可以包含多条报警记录
 * routNo对应其所属的报警表单的statNO
 */
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Data
@Table(name = "chkroutes")
public class ChkRoutes {
    /**
     * 主键ID
     */
    @Id
    @Column(name = "routid")
    private Integer routID;

    /**
     * 状态码
     */
    @Column(name = "routno")
    private String routNO;

    /**
     * 状态码编号
     */
    @Column(name = "routstatus")
    private String routStatus;

    /**
     * 地区编号
     */
    @Column(name = "routfrom")
    private String routFrom;

    /**
     * 操作者,admin,不确定
     */
    @Column(name = "routoperator")
    private String routOperator;

    /**
     * 最后修改时间
     */
    @Column(name = "routstamp")
    private String routStamp;

    /**
     * 内容,数据库无数据,不确定
     */
    @Column(name = "routmemo", length = 2000)
    private String routMemo;

    /**
     * 操作者,不确定字段
     */
    @Column(name = "routinspector")
    private String routInspector;

    @Column(name = "routinspectorx")
    private String routInspectorX;

    @Column(name = "routconcerned")
    private String routConcerned;

    @Column(name = "routconcernedx")
    private String routConcernedX;

    @Column(name = "relationid")
    private Integer relationId;
}
