package com.zjty.fp.api.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author C
 * 处理记录
 * 一套报警记录中可以包含多条处理记录
 * chkNO对应其所属报警记录
 */
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Data
@Table(name = "b_pclog")
public class PcLog {

    /**
     * 序号
     */
    @Id
    @Column(name = "RECNO")
    private Integer recno;

    /**
     * 不详
     */
    @Column(name = "Serverid")
    private Integer serverId;

    /**
     * mac地址
     */
    @Column(name = "MACSTR")
    private String macStr;

    /**
     * 主机名
     */
    @Column(name = "Hostname")
    private String hostname;

    /**
     * 不详
     */
    @Column(name = "Hostid")
    private Integer hostID;

    /**
     * 内网ip地址
     */
    @Column(name = "IPSTR")
    private String ipStr;

    /**
     * 报警时间
     */
    @Column(name = "Outbegin")
    private Date outbegin;

    /**
     * 报警时间,同outbegin字段
     */
    @Column(name = "Outend")
    private Date outend;

    /**
     * 报警时间,精确到秒,string类型
     */
    @Column(name = "STRbegin")
    private String strBegin;

    /**
     * 同strbegin字段
     */
    @Column(name = "STRend")
    private String strEnd;

    /**
     * 无内容
     */
    @Column(name = "Tlocate")
    private String tlocate;

    /**
     * 操作系统名称
     */
    @Column(name = "TOS")
    private String tos;

    /**
     * 主板序列号
     */
    @Column(name = "Mastercode")
    private String masterCode;

    /**
     * 硬盘序列号
     */
    @Column(name = "HDCode")
    private String hdCode;

    /**
     * 责任人
     */
    @Column(name = "Tuser")
    private String tUser;

    /**
     * 均为0
     */
    @Column(name = "SEClevel")
    private Integer secLevel;

    /**
     * 用户端软件
     */
    @Column(name = "TVer")
    private String tver;

    /**
     * 外联描述信息
     */
    @Column(name = "Tmemo")
    private String tmemo;

    /**
     * 均为1
     */
    @Column(name = "Tmode")
    private String tmode;

    /**
     * 外网ip地址
     */
    @Column(name = "Outipstr")
    private String outIpstr;

    /**
     * 地区名称
     */
    @Column(name = "zonecode")
    private String zoneCode;

    /**
     * 均为null
     */
    @Column(name = "unitcode")
    private String unitCode;

    /**
     * 单位名称
     */
    @Column(name = "unitname")
    private String unitName;

    /**
     * 部门名称
     */
    @Column(name = "deptment")
    private String deptment;

    /**
     * 1或0,意思不详
     */
    @Column(name = "Chkstatus")
    private Integer chkStatus;

    /**
     * 网卡信息
     */
    @Column(name = "TCard")
    private String tCard;

    /**
     * 厂家编号
     */
    @Column(name = "TCompany")
    private String tCompany;

    /**
     * 转发
     */
    @Column(name = "TReserve")
    private String tReserve;

    /**
     * 时间类型,字义不知
     */
    @Column(name = "Chkstamp")
    private Date chkStamp;

    /**
     * 部门等级,不确定
     */
    @Column(name = "unittype")
    private Integer unitType;

    /**
     * 操作人
     */
    @Column(name = "Chkoperator")
    private String chkOperator;

    /**
     * 均为null,用途不明
     */
    @Column(name = "chkmemo")
    private String chkMemo;

    /**
     * 状态码,作关联用
     */
    @Column(name = "chkno")
    private String chkNo;
}
