package com.zjty.fp.api.vomp.subject.entity.vo;

import com.zjty.fp.api.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>Description : fp-api
 * <p>Date : 2018/11/1 16:16
 * <p>@author : C
 */
@AutoDocument
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "vomp首页数据模型", description = "里面包含了vomp平台的首页数据")
public class VompFpVo {

    /**
     * 监控终端数量
     */
    @ApiModelProperty(value = "监控终端数量", example = "100")
    private Integer pcCount;

    /**
     * 告警数量
     */
    @ApiModelProperty(value = "告警数量", example = "4")
    private Integer alarmCount;

    /**
     * 报警率
     */
    @ApiModelProperty(value = "报警率(告警数量/监控终端数量 精确到2位小数点)", example = "0.04")
    private String alarmRate;
}
