package com.zjty.fp.api.vomp.subject.service.updater.impl;

import com.zjty.fp.api.misc.utils.JacksonUtil;
import com.zjty.fp.api.vomp.subject.repository.remote.*;
import com.zjty.fp.api.vomp.subject.service.updater.VompFetcher;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.zjty.fp.api.vomp.base.enums.VompCatalogs.*;
import static com.zjty.fp.api.vomp.base.enums.VompPlatform.PLATFORM;

@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Slf4j
@Service
public class VompFetcherImpl implements VompFetcher {
    @Autowired
    ChkRoutesRepository chkRoutesRepository;
    @Autowired
    ChkStatesRepository chkStatesRepository;
    @Autowired
    PcLogRepository pcLogRepository;
    @Autowired
    ServerStatusRepository serverStatusRepository;
    @Autowired
    ZoneRepository zoneRepository;
    @Autowired
    FileCreator fileCreator;

    @Override
    public void fetchData() {
        //5种数据分别写入
        uploadChkRoutes();
        uploadChkStates();
        uploadPcLog();
        uploadServerStatus();
        uploadZone();
    }

    private void createFileThenUploadToFtp(String catalog,String data){
        String subName = PLATFORM.getName();
        fileCreator.createFile(subName, catalog, data);
        log.info("[{}] {}写入完毕",subName,catalog);
    }

    private void uploadChkRoutes() {
        String data = JacksonUtil.toJSon(chkRoutesRepository.findAll());
        createFileThenUploadToFtp(CHKROUTES.getName(),data);
    }

    private void uploadChkStates() {
        String data = JacksonUtil.toJSon(chkStatesRepository.findAll());
        createFileThenUploadToFtp(CHKSTATES.getName(),data);
    }

    private void uploadPcLog() {
        String data = JacksonUtil.toJSon(pcLogRepository.findAll());
        createFileThenUploadToFtp(PCLOG.getName(),data);
    }

    private void uploadServerStatus() {
        String data = JacksonUtil.toJSon(serverStatusRepository.findAll());
        createFileThenUploadToFtp(SERVERSTATUS.getName(),data);

    }

    private void uploadZone() {
        String data = JacksonUtil.toJSon(zoneRepository.findAll());
        createFileThenUploadToFtp(ZONE.getName(),data);
    }

}
