package com.zjty.fp.api.vomp.task;

import com.zjty.fp.api.vomp.subject.service.updater.VompFetcher;
import com.zjty.fp.api.vomp.subject.service.updater.impl.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/11/27 14:28
 * <p>@author : C
 * 用于定义该子项目的定时任务
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Component
@Slf4j
public class VompTasks {
    /**
     * 采集工具类 将数据以文件形式保存
     */
    @Autowired
    VompFetcher vompFetcher;

    /**
     * 以直连数据库模式更新文件的工具类
     */
    @Autowired
    VompDataDbUpdater dataDbUpdater;
    /**
     * 以从FTP下载文件并读取的模式更新文件的工具类
     */
    @Autowired
    VompDataDlUpdater dataDlUpdater;
    /**
     * 以读取文件模式更新文件的工具类
     */
    @Autowired
    VompDataRdUpdater dataRdUpdater;
    /**
     * 更新缓存数据的工具类
     */
    @Autowired
    VompMapUpdater mapUpdater;

    /**
     * 60分钟执行一次 读取
     */
//    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 60)
    public void updateData() {
        dataDbUpdater.updateData();
        mapUpdater.updateData();
    }

    /**
     * 3分钟执行一次
     */
//    @Scheduled(initialDelay = 4000, fixedRate = 60000 * 3)
    public void updateRedisData() {
        log.info("[vomp] 开始更新缓存数据");
        mapUpdater.updateData();
        log.info("[vomp] 更新缓存数据完毕");
    }
}
