package com.zjty.fp.api.misc.utils;

import java.text.NumberFormat;

/**
 * <p>Description : fp-fp
 * <p>Date : 2018/10/30 15:31
 * <p>@author : Mcj
 */
public class AlgorithmUtil {
    /**
     * 计算百分比
     *
     * @param num1 被除数
     * @param num2 除数
     * @return 百分比字符串
     */
    public static String percentage(double num1, double num2) {
        if (num1 == 0 && num2 == 0) {
            return "0%";
        }
        double ratio = num1 / num2;
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(2);//设置保留几位小数
        return format.format(ratio);
    }

    /**
     * 计算环比
     *
     * @param num1 今日报警
     * @param num2 昨日报警
     * @return 百分比
     */
    public static String linkRatio(double num1, double num2) {
        if (num1 == 0) {
            return "0%";
        }
        if (num2 == 0) {
            return "100%";
        }
        double ratio = num1 - num2;
        double linkRatio = ratio / num2;
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(2);//设置保留几位小数
        return format.format(linkRatio);
    }
}
