package com.zjty.fp.api.misc.utils;

import lombok.extern.slf4j.Slf4j;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

/**
 * @author LJJ
 * on 18-12-27
 */
@Slf4j
public class TimeUtil {

    /**
     * 获取上一小时时间string 用于拼接restful fp 的url
     *
     * @return yyyy-MM-dd%20HH
     */
    public static String getMinusHoursTime() {
        return LocalDateTime.now().minusHours(1).format(DateTimeFormatter.ofPattern("yyyy-MM-dd%20HH"));
    }

    /**
     * 获取今日时间string
     *
     * @return yyyyMMdd
     */
    public static String getToday() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    /**
     * 获取今天开始时间的时间戳
     *
     * @return long
     */
    public static Long getTodayStartTime() {
        String a = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00";
        return stringToLong("yyyy-MM-dd HH:mm:ss", a);
    }

    /**
     * 获取今天结束事件的时间戳
     *
     * @return long 13
     */
    public static Long getTodayEndTime() {
        String a = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59";
        return stringToLong("yyyy-MM-dd HH:mm:ss", a);
    }

    /**
     * long -> String
     *
     * @param format 指定格式,如:yyyy-MM-dd HH:mm:ss
     * @param time   long
     * @return String
     */
    public static String longToString(String format, Long time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return df.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.of("Asia/Shanghai")));
    }


    /**
     * String -> long
     *
     * @param format 指定格式,如:yyyy-MM-dd HH:mm:ss
     * @param time   yyyy-MM-dd HH:mm:ss
     * @return 13位long
     */
    public static Long stringToLong(String format, String time) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        LocalDateTime parse = LocalDateTime.parse(time, df);
        return LocalDateTime.from(parse).atZone(ZoneId.of("Asia/Shanghai")).toInstant().toEpochMilli();
    }

}
