package com.zjty.fp.api.pssp.base.beans;

import com.zjty.fp.api.pssp.base.constant.DictConst;
import com.zjty.fp.api.pssp.subject.entity.location.Region;
import com.zjty.fp.api.pssp.subject.entity.location.Website;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import com.zjty.fp.api.pssp.subject.service.WebsiteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

import java.util.Map;

/**
 * PsspInitialRunner 初始化Runner程序
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 17:15
 */
@Slf4j
@Configuration
public class PsspInitialRunner {


    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private RegionService regionService;

    @Order(100)
    @Bean
    public CommandLineRunner initializeDictMap() {
        return args -> {
            log.info("[pssp] 正在尝试初始化 pssp 网站Map字段表");

//            List<Website> -> key : id , value : Website
            Map<Long, Website> websiteMap = websiteService.findDictMap();
            DictConst.WEBSITE_MAP = websiteMap;

            log.info("[pssp] 初始化 pssp 网站字典Map完毕,字典表数据大小为{}", websiteMap.size());

            log.info("[pssp] 正在尝试初始化 pssp 地区Map字段表");

//            List<Website> -> key : code , value : Region
            Map<String, Region> regionMap = regionService.findDictMap();
            DictConst.REGION_MAP = regionMap;

            log.info("[pssp] 初始化 pssp 地区字典Map完毕,字典表数据大小为{}", regionMap.size());
        };
    }


}
