package com.zjty.fp.api.pssp.subject.entity.remote;

import com.zjty.fp.api.pssp.base.beans.BeanHelper;
import com.zjty.fp.api.pssp.subject.entity.location.Region;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * RemoteRegion. 源仓库地区表
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 15:46
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "t_dic_org")
public class RemoteRegion {

    /**
     * 地区编号
     */
    @Id
    @GenericGenerator(name = "myGen", strategy = "assigned")
    @GeneratedValue(generator = "myGen")
    private String code;

    /**
     * 地区名称
     */
    private String name;

    /**
     * 地区短名称
     */
    @Column(name = "shortname")
    private String shortName;

    /**
     * 地区等级
     */
    @Column(name = "level_")
    private Integer level;

    /**
     * 是否被删除
     */
    private Integer deleted;


    /**
     * 将源数据对象转化为融合平台子平台数据对象
     *
     * @return {@link Region}
     */
    public Region toDo() {
        ModelMapper mapper = BeanHelper.getPsspMapper();
        return mapper.map(this, Region.class);
    }


}
