package com.zjty.fp.api.pssp.subject.service;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * PsspTimeService.
 * Pssp 通用接口,用于扩展基础的接口，增加了时间相关的接口
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 16:19
 */
public interface PsspTimeService<T> extends PsspService<T>{

    /**
     *
     * 根据时间范围分页查询结果集
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param pageable  分页参数
     * @return 结果集
     */
    Page<T> findAllDataBetweenTime(LocalDate startTime, LocalDate endTime, Pageable pageable);

    /**
     * 获取指定年月的数据
     *
     * @param year  年
     * @param month 月
     * @return 指定年月的数据集合
     */
    List<T> findAllDataByMonth(int year, int month);

    /**
     * 获取指定日的数据
     *
     * @param year  年
     * @param month 月
     * @param day   日
     * @return 指定年月日的数据集合
     * @throws Exception 异常
     */
    List<T> findAllDataByDate(int year, int month, int day) throws Exception;


    /**
     * 获取最近N天的数据
     *
     * @param days 指定最近几天的时间
     * @return 最近指定天数的数据
     */
    List<T> findRecentDaysData(int days);

    /**
     * 获取指定时间内最近N天的数据
     *
     * @param specifiedTime 指定时间
     * @param days          指定最近几天的时间
     * @return 最近指定天数的数据
     */
    List<T> findRecentDaysData(LocalDateTime specifiedTime, int days);
}
