package com.zjty.fp.api.pssp.task;


import com.zjty.fp.api.misc.utils.DateTimeUtil;
import com.zjty.fp.api.pssp.base.aspect.EnablePsspSchProtect;
import com.zjty.fp.api.pssp.base.aspect.PsspScheduleTrigger;
import com.zjty.fp.api.pssp.subject.repository.location.AlertRepository;
import com.zjty.fp.api.pssp.subject.repository.remote.RemoteAlertRepository;
import com.zjty.fp.api.pssp.subject.service.AlertService;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import com.zjty.fp.api.pssp.subject.service.WebsiteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * <p>采集数据任务类</p>
 * 有以下任务
 * <li>采集所有历史数据</li>
 * <li>采集更新的增量数据</li>
 * 该类的的计划任务是否执行由变量{@link #trigger}控制，实现逻辑由AOP{@link PsspScheduleTrigger}控制,
 * 由{@link EnablePsspSchProtect}该注解触发
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 */
@SuppressWarnings("unused")
@Slf4j
@Configuration
public class CollectDataTask {

    /**
     * 用于控制计划任务的开关,一般来讲开关默认开启,当进行历史数据同步的时候,开关关闭
     */
    public static boolean trigger = true;
    private static String dynamicTableMonth;

    static {
        dynamicTableMonth = DateTimeUtil.formatDateTimetoString(new Date(), "yyyyMM");
    }

    @Autowired
    private AlertService alertService;

    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private RegionService regionService;

    private int count = 0;

    @Autowired
    private AlertRepository localPsspRep;

    @Autowired
    private RemoteAlertRepository remotePsspRep;

    public static String getDynamicTableMonth() {
        return dynamicTableMonth;
    }

    public static void setDynamicTableMonth(LocalDate time) {
        dynamicTableMonth = time.format(DateTimeFormatter.ofPattern("yyyyMM"));
    }

    public static void setDynamicTableMonth(Date time) {
        dynamicTableMonth = DateTimeUtil.formatDateTimetoString(time, "yyyyMM");
    }


    /**
     * This method is for debug
     */
//    @EnablePsspSchProtect
//    @Scheduled(cron = "0 0/1 * * * ?")
    public void checkPsspDataCount() {
        long simcCount = remotePsspRep.count();
        long apiCount = localPsspRep.count();
        log.debug("[pssp] [count_check] simc={} api={}",
                simcCount, apiCount);
    }

    /**
     * 抓取更新的网站的数据,当前为1h/次
     */
    @EnablePsspSchProtect
//    @Scheduled(cron = "0 0 0/1 * * ?")
    public void collectWebsiteData() {
        log.info("[pssp] [定时任务]抓取更新的网站数据");
        websiteService.fetchUpdatedData();
    }

    /**
     * 抓取更新的地区的数据,当前为1h/次
     */
    @EnablePsspSchProtect
//    @Scheduled(cron = "0 0 0/1 * * ?")
    public void collectRegionData() {
        log.info("[pssp] [定时任务]抓取更新的区域数据");
        regionService.fetchUpdatedData();
    }

    /**
     * 抓取更新的报警数据,当前为1min/次
     */
    @EnablePsspSchProtect
//    @Scheduled(cron = "30 0/1 * * * ?")
    public void collectAlertData() {
        log.info("[pssp] [定时任务] 抓取更新的报警数据");
        alertService.fetchUpdatedData();

    }

    /**
     * 在每个月月初的第10分钟，执行一次上个月的数据丢失补偿任务,大体逻辑如下
     * <li>1.关闭其他计划任务</li>
     * <li>2.将当前动态处理的表时间更改为上个月时间</li>
     * <li>3.执行数据更新任务</li>
     * <li>4.更正时间,开启其他计划任务></li>
     */
//    @Scheduled(cron = "0 10 0 1 * ?")
    @EnablePsspSchProtect
    public void replenishMysqlDataMonthly() {
        log.info("[pssp] [定时任务] 正在执行月末数据补偿任务,暂停其他计划任务,要补偿的月份数据是 {}", LocalDate.now().minusMonths(1L).toString());
        setDynamicTableMonth(LocalDate.now().minusMonths(1L));
        alertService.fetchUpdatedData();
        log.info("[pssp] [定时任务] 月末数据补偿任务执行完毕,更正时间,开启其他计划任务");
        setDynamicTableMonth(LocalDate.now());
    }



}
