package com.zjty.fp.api.vomp.subject.controller;

import com.zjty.fp.api.vomp.subject.entity.localdo.*;
import com.zjty.fp.api.vomp.subject.service.api.VompApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static org.springframework.http.ResponseEntity.ok;

/**
 * @author C
 * 向网安提供数据的接口
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@RestController
@RequestMapping("/api/vomp")
public class VompApiController {
    @Autowired
    VompApiService vompApiService;

    @GetMapping("/alarm")
    public ResponseEntity<List<VompAlarm>> alarm() {
        return ok(vompApiService.getAlarmList());
    }

    @GetMapping("/handinginfo")
    public ResponseEntity<List<VompHandingInfo>> handingInfo() {
        return ok(vompApiService.getHandingInfoList());
    }

    @GetMapping("/pcinfo")
    public ResponseEntity<List<VompPcInfo>> pcInfo() {
        return ok(vompApiService.getPcInfoList());
    }

    @GetMapping("/status")
    public ResponseEntity<List<VompStatus>> status() {
        return ok(vompApiService.getStatusList());
    }

    @GetMapping("/zone")
    public ResponseEntity<List<VompZone>> zone() {
        return ok(vompApiService.getZoneList());
    }
}

