package com.zjty.fp.api.vomp.subject.service.api;

import com.zjty.fp.api.misc.utils.DateTimeUtil;
import com.zjty.fp.api.vomp.subject.entity.localdo.VompAlarm;
import com.zjty.fp.api.vomp.subject.entity.localdo.VompPcInfo;
import com.zjty.fp.api.vomp.subject.service.cache.VompTransCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * <p>Description : fusion-platform
 * <p>Date : 2018/12/17 15:49
 * <p>@author : C
 */
@SuppressWarnings("SpringAutowiredFieldsWarningInspection")
@Component
public class VompJudgeHelper {
    @Autowired
    VompTransCache vompTransCache;

    /**
     * 根据zoneID判断是否是杭州内的区域
     */
    public boolean isInHangzhou(VompAlarm alarm) {
        String zoneId = alarm.getZoneCode();
        return Objects.equals(vompTransCache.getZoneId_ParentZoneId_Map().get(zoneId), "3301");
    }

    /**
     * 根据zoneID判断是否是杭州内的区域
     */
    public boolean isInHangzhou(VompPcInfo pcInfo) {
        String zoneId = pcInfo.getZoneId();
        return Objects.equals(vompTransCache.getZoneId_ParentZoneId_Map().get(zoneId), "3301");
    }

    /**
     * 根据时间判断是否是在本年度
     */
    public boolean isInCurrentYear(VompAlarm alarm) {
        Date outBegin = alarm.getOutBegin();
        boolean isInThisYear;
        Calendar calendar = Calendar.getInstance();
        Integer currentYear = calendar.get(Calendar.YEAR);
        String outBeginStr = DateTimeUtil.formatDateTimetoString(outBegin, "YYYY-MM-dd");
        Integer outBeginYear = Integer.valueOf(outBeginStr.substring(0, 4));
        isInThisYear = currentYear.equals(outBeginYear);
        return isInThisYear;
    }

    /**
     * 根据时间字符串判断是否是在今天
     */
    public boolean isInToday(VompAlarm alarm) {
        String outBegin = new SimpleDateFormat("yyyy-MM-dd").format(alarm.getOutBegin());
        boolean isInToday;
        String today = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        isInToday = today.equals(outBegin.substring(0, today.length()));
        return isInToday;
    }

    /**
     * 判断alarm的发生时间是否是在指定时间之后
     */
    public boolean isAfterTime(VompAlarm alarm, Date date) {
        Date fetchDate = alarm.getOutBegin();
        return fetchDate.after(date);
    }

    /**
     * 判断是否逻辑存在
     * VompAlarm有一个字段是status状态码
     * 其中一个状态是“删除”。(状态码为“2”代表“删除”)
     * 状态为“删除”的对象为逻辑删除状态，不应当给出去。
     * 非逻辑删除的数据则是逻辑存在 可以给出去。
     *
     * @param alarm 被判断的VompAlarm对象
     * @return 是否逻辑存在
     */
    public Boolean logicalExisted(VompAlarm alarm) {
        return !Objects.equals(alarm.getStatStatus(), "2");
    }
}
