package com.zjty.fp.api.misc.utils;

import com.google.common.collect.Lists;
import com.zjty.fp.api.misc.entity.ImportAds;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import static com.zjty.fp.api.misc.entity.PsspCount.*;

/**
 * <p>Description : vompin
 * <p>Date : 2018/9/29 15:44
 * <p>@author : Matrix [xhyrzldf@foxmail.com]
 */
@SuppressWarnings({"unused", "UnusedReturnValue"})
@Component
@Scope("prototype")
@Slf4j
public class FileReader {


    public List<String> readFileData(String subName, String catalog) {
        List<String> data = Lists.newArrayList();
        String localFilePath = ImportAds.IMPORT_URL + "files/" + subName + "/" + catalog + "/";
        String fileName = getFileNameByDate(subName, catalog);
        File file = new File(localFilePath + fileName);
        Path path = Paths.get(localFilePath + fileName);
        try {
            data = Files.readAllLines(path);
        } catch (IOException e) {
            log.info("读取文件时出现异常：" + e);
        }
        return data;
    }

    public String readFileAndUnzip(String countAddress, String subName, String catalog) {
        String data = "";
        String localFilePath = ImportAds.IMPORT_URL + "files/" + subName + "/" + catalog + "/";
        String fileName = getPsspFileName(countAddress, subName, catalog);
        File file = new File(localFilePath + fileName);
        Path path = Paths.get(localFilePath + fileName);
        try {
            data = new String(Files.readAllBytes(path));
            log.info("文件读取成功,长度为 : {}", data.length());

            //读取完之后unzip一下
            String unzippedString = DeflaterUtils.unzipString(data);

            //更新count
            updateCount(countAddress);
            return unzippedString;
        } catch (IOException e) {
            log.info("[pssp] 读取文件时出现异常,准备核对Count值采取策略：" + e);
            //读取全局的count值，如果全局的count值大于当前count值，则继续增加count值，否则count值不变
            int globalCount = readCount(subName, countAddress);
            if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
                if (globalCount >= alert_count) {
                    log.info("[pssp] 全局alertCount值为{},当前alertCount值为{},采取策略继续增加当前Count值", globalCount, alert_count);
                    alert_count++;
                } else {
                    log.info("[pssp] 全局alertCount值为{},当前alertCount值为{},采取策略当前Count值保持不变", globalCount, alert_count);
                }
            }

            if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                if (globalCount >= website_count) {
                    log.info("全局websiteCount值为{},当前websiteCount值为{},采取策略继续增加当前Count值", globalCount, website_count);
                    website_count++;
                } else {
                    log.info("全局websiteCount值为{},当前websiteCount值为{},采取策略当前Count值保持不变", globalCount, website_count);
                }
            }
            return "";
        }

    }

    /**
     * 读取全局Count值
     *
     * @return count值
     */
    private int readCount(String subName, String countAddress) {
        String count = "";
        String localFilePath = ImportAds.IMPORT_URL + "files/" + subName + "/count/";
        String fileName = "";
        if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
            fileName = "alert.txt";
        } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
            fileName = "website.txt";
        }

        String countPath = localFilePath + fileName;

        Path path = Paths.get(countPath);
        try {
            count = new String(Files.readAllBytes(path));
        } catch (IOException e) {
            log.info("读取全局Count文件时出现异常：" + e);
            return 0;
        }

        return Integer.parseInt(count);

    }

    public void deleteFile(String countAddress, String subName, String catalog) {
        String localFilePath = "files/" + subName + "/" + catalog + "/";
        String fileName = getPsspFileName(countAddress, subName, catalog);
        Path path = Paths.get(localFilePath + fileName);
        try {
            log.info("[pssp] 即将删除 {} 文件", fileName);
            Files.deleteIfExists(path);
            log.info("[pssp] 删除 {} 文件成功", fileName);
        } catch (IOException e) {
            log.warn("[pssp] 删除失败, 原因 : {}", e.toString());
        }
    }

    private String getPsspFileName(String countAddress, String subName, String catalog) {

        //count 先从内存里取读 内存里读不到从磁盘读
        int count = -1;
        if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
            count = alert_count;

        } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
            count = website_count;

        }

        //如果count为初始值-1,则代表还没有从文件中读取之前的记录
        if (count == -1) {
            //读取文件获得文件编号后缀值
            Path path = Paths.get(countAddress);
            List<String> data = Lists.newArrayList();

            try {
                data = Files.readAllLines(path);
            } catch (IOException e) {
                log.info("[pssp]读取文件时出现异常：" + e);
            }
            count = data.get(0) == null ? 0 : Integer.parseInt(data.get(0));
        }

        if (count <= 0) {
            count = 0;
        }

        String psspFileName = subName + "-" + catalog + count + ".txt";
        log.info("[pssp]成功生成文件名:{}", psspFileName);

        return psspFileName;
    }

    /**
     * 根据日期生成文件名
     * 以天为单位
     * 文件名格式：平台名-种类-时间（yyyyMMdd）.txt
     */
    private String getFileNameByDate(String subName, String catalog) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return subName + "-" + catalog + "-" + sdf.format(new Date()) + ".txt";
    }

    /**
     * 更新Count值，具体为Count+1
     */
    private void updateCount(String countAddress) {
        if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
            alert_count += 1;
        } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
            website_count += 1;
        }
        //写入到count文件中去
        Path countPath = Paths.get(countAddress);
        //先删除原有的count文件，再写入现有的
        try {
            Files.deleteIfExists(countPath);
        } catch (IOException e) {
            log.warn("删除原count文件失败!原因:{}", e.toString());
        }

        boolean countMake = createFilePath(new File(COUNT_PATH));

        if (countMake) {
            try {
                if (countAddress.equals(COUNT_ADDRESS_ALERT)) {
                    Files.write(Paths.get(countAddress), String.valueOf(alert_count).getBytes());
                    log.info("[pssp]磁盘count_alert 值更新成功:count = {}", alert_count);

                } else if (countAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                    Files.write(Paths.get(countAddress), String.valueOf(website_count).getBytes());
                    log.info("[pssp]磁盘count_website 值更新成功:count = {}", website_count);
                }
            } catch (IOException e) {
                log.info("[pssp]生成文件时出现异常：" + e);
            }
        }
    }

    /**
     * 生成指定的文件夹路径
     * 若文件夹不存在则创建
     */
    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }
}
