package com.zjty.fp.api.pssp.base.beans;

import com.google.common.collect.Lists;
import com.zjty.fp.api.pssp.base.constant.DictConst;
import com.zjty.fp.api.pssp.subject.entity.location.Region;
import com.zjty.fp.api.pssp.subject.entity.location.Website;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import com.zjty.fp.api.pssp.subject.service.WebsiteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;

import static com.zjty.fp.api.misc.entity.PsspCount.*;

/**
 * PsspInitialRunner 初始化Runner程序
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 17:15
 */
@Slf4j
@Configuration
public class PsspInitialRunner {

    @Order(100)
    @Bean
    public CommandLineRunner initializeDictMap() {
        return args -> {
            initCount("COUNT_ALERT", COUNT_ADDRESS_ALERT, alert_count);
            initCount("COUNT_WEBSITE", COUNT_ADDRESS_WEBSITE, website_count);
        };
    }

    private void initCount(String countFileName, String CountAddress, int countVar) {
        log.info("[pssp] 正在尝试初始化 {} 文件", countFileName);

        boolean countExists = Files.exists(Paths.get(CountAddress));

        if (countExists) {
            log.info("[pssp] 磁盘已存在 {} 文件，跳过初始化流程，将磁盘的 {} 读取入内存中", countFileName, countFileName);
            //读取文件获得文件编号后缀值
            Path path = Paths.get(CountAddress);
            List<String> data = Lists.newArrayList();

            try {
                data = Files.readAllLines(path);
            } catch (IOException e) {
                log.info("[pssp] 读取文件时出现异常：" + e);
            }
            countVar = data.get(0) == null ? 0 : Integer.parseInt(data.get(0));

            if (CountAddress.equals(COUNT_ADDRESS_ALERT)) {
                alert_count = countVar;
            } else if (CountAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                website_count = countVar;
            }
        } else {
            log.info("[pssp] 磁盘不存在 {} 文件，初始化 {} 文件", countFileName, countFileName);
            boolean countMake = createFilePath(new File(COUNT_PATH));

            countVar = 0;
            if (countMake) {
                try {
                    Files.write(Paths.get(CountAddress), String.valueOf(countVar).getBytes());
                    log.info("[pssp]磁盘 {} 值更新成功:count = {}", countFileName, countVar);
                } catch (IOException e) {
                    log.info("[pssp]生成文件时出现异常：" + e);
                }
            }
            log.info("[pssp]初始化 {} 文件完毕!", countFileName);

            if (CountAddress.equals(COUNT_ADDRESS_ALERT)) {
                alert_count = countVar;
            } else if (CountAddress.equals(COUNT_ADDRESS_WEBSITE)) {
                website_count = countVar;
            }
        }
    }

    private boolean createFilePath(File file) {
        return file.exists() || file.mkdirs();
    }


}
