package com.zjty.fp.api.pssp.config.algorithm;

import io.shardingsphere.api.algorithm.sharding.PreciseShardingValue;
import io.shardingsphere.api.algorithm.sharding.standard.PreciseShardingAlgorithm;
import lombok.RequiredArgsConstructor;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

/**
 * =
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 * @Date : 18-8-29
 */
@RequiredArgsConstructor
public class AlertPreShardAlgo implements PreciseShardingAlgorithm<Date> {

    private final String tablePrefix;

    @Override
    public String doSharding(Collection<String> collection, PreciseShardingValue<Date> preciseShardingValue) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
        return tablePrefix + formatter.format(preciseShardingValue.getValue());
    }
}
