package com.zjty.fp.api.pssp.subject.controller;


import com.zjty.fp.api.pssp.subject.service.AlertService;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import com.zjty.fp.api.pssp.subject.service.WebsiteService;
import com.zjty.fp.api.pssp.task.CollectDataTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author matrix
 */
@RestController
@RequestMapping("/pssp/test")
public class PsspTestController {


    @Autowired
    AlertService alertService;

    @Autowired
    WebsiteService websiteService;

    @Autowired
    RegionService regionService;

    @Autowired
    CollectDataTask psspTask;

    /**
     * 抓取更新的数据
     */
    @GetMapping("/alerts/updated")
    public ResponseEntity<String> fetchUpdatedAlerts() {
        alertService.fetchUpdatedData();
        return ResponseEntity.ok("update alerts data success");
    }

    /**
     * 抓取更新的数据
     */
    @GetMapping("/websites/updated")
    public ResponseEntity<String> fetchUpdatedWebsites() {
        websiteService.fetchUpdatedData();
        return ResponseEntity.ok("update websites data success ");
    }

    /**
     * 抓取更新的数据
     */
    @GetMapping("/regions/updated")
    public ResponseEntity<String> fetchUpdatedRegions() {
        regionService.fetchUpdatedData();
        return ResponseEntity.ok("update regions data success ");
    }

}
