package com.zjty.fp.api.pssp.subject.entity.remote;

import com.zjty.fp.api.pssp.base.beans.BeanHelper;
import com.zjty.fp.api.pssp.subject.entity.location.Alert;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;
import java.util.Date;

/**
 * @author matrix
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
@Table(name = "alert", catalog = "remote")
public class RemoteAlert {
    /**
     * 数据ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 所属地区编号1
     */
    @Column(name = "code_org_l1")
    private Integer codeOrgL1;

    /**
     * 所属地区编号2
     */
    @Column(name = "code_org_l2")
    private Integer codeOrgL2;

    /**
     * 网站入口分类
     */
    @Column(name = "id_web_category")
    private Integer idWebCategory;

    /**
     * 网站入口信息
     */
    @Column(name = "id_web")
    private Integer idWeb;

    /**
     * 所匹配到的关键字
     */
    @Column(name = "match_keyword")
    private String matchKeyword;

    /**
     * 数据的标题
     */
    @Column(name = "title")
    private String title;

    /**
     * 数据摘要
     */
    @Column(name = "abstract")
    private String abs;

    /**
     * 源网页地址
     */
    @Column(name = "web_url")
    private String webUrl;

    /**
     * 本地预览（快照）地址
     */
    @Column(name = "web_snapshot")
    private String webSnapshot;

    /**
     * 源附件地址
     */
    @Column(name = "doc_url")
    private String docUrl;

    /**
     * 本地预览（快照）地址
     */
    @Column(name = "doc_snapshot")
    private String docSnapshot;

    /**
     * 数据创建时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "tm_create")
    private Date tmCreate;

    /**
     * 数据抓取时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "tm_fetch")
    private Date tmFetch;

    /**
     * 处理人ID
     */
    @Column(name = "handler_user")
    private Integer handlerUser;

    @Column(name = "suspicious_user")
    private Integer suspiciousUser;

    @Column(name = "confidential_user")
    private Integer confidentialUser;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "tm_suspicious")
    private Date tmSuspicious;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "tm_confidential")
    private Date tmConfidential;

    @Column(name = "suspicious_remark")
    private String susRemark;

    @Column(name = "confidential_remark")
    private String conRemark;

    /**
     * 数据是否为压缩类型
     */
    @Column(name = "e_in_zip")
    private Integer eInZip;

    /**
     * 数据是否已读
     */
    @Column(name = "e_ident")
    private Integer eIdent;

    /**
     * 告警等级（红，黄，绿）
     */
    @Column(name = "e_alert")
    private Integer eAlert;

    /**
     * 数据类型
     */
    @Column(name = "e_type")
    private Integer eType;

    /**
     * 处理状态
     */
    @Column(name = "e_status")
    private Integer eStatus;


    /**
     * 将源数据对象转化为融合平台子平台数据对象
     *
     * @return {@link Alert}
     */
    public Alert toDo() {
        ModelMapper mapper = BeanHelper.getPsspMapper();
        Alert alert = mapper.map(this, Alert.class);
        alert.setCodeOrg(this.codeOrgL1);
        alert.setId(this.id);
        return alert;
    }
}