package com.zjty.fp.api.pssp.subject.service.impl;

import com.zjty.fp.api.pssp.subject.entity.location.Region;
import com.zjty.fp.api.pssp.subject.repository.location.RegionRepository;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * RegionServiceImpl. 区域接口实现类
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2019-04-08 at 16:33
 */
@Slf4j
@Service
@Transactional(rollbackOn = Exception.class)
public class RegionServiceImpl implements RegionService {

    @Autowired
    private RegionRepository regionRepository;

    @Override
    public void fetchUpdatedData() {
        log.info("[pssp] 正在执行地区数据的更新");
        log.info("[pssp] 本次更新没有更新区域数据");
    }

    @Override
    public List<Region> findAllData() {
        return regionRepository.findAll();
    }

    @Override
    public Map<String, Region> findDictMap() {

        return regionRepository.findAll()
                .stream()
                .collect(Collectors
                        .toMap(Region::getCode, Function.identity()));
    }
}
