package com.zjty.fp.api.pssp.task;


import com.zjty.fp.api.misc.utils.DateTimeUtil;
import com.zjty.fp.api.pssp.base.aspect.EnablePsspSchProtect;
import com.zjty.fp.api.pssp.base.aspect.PsspScheduleTrigger;
import com.zjty.fp.api.pssp.subject.repository.location.AlertRepository;
import com.zjty.fp.api.pssp.subject.service.AlertService;
import com.zjty.fp.api.pssp.subject.service.RegionService;
import com.zjty.fp.api.pssp.subject.service.WebsiteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * <p>采集数据任务类</p>
 * 有以下任务
 * <li>采集所有历史数据</li>
 * <li>采集更新的增量数据</li>
 * 该类的的计划任务是否执行由变量{@link #trigger}控制，实现逻辑由AOP{@link PsspScheduleTrigger}控制,
 * 由{@link EnablePsspSchProtect}该注解触发
 *
 * @author : Matrix [xhyrzldf@foxmail.com]
 */
@SuppressWarnings("unused")
@Slf4j
@Configuration
public class CollectDataTask {

    /**
     * 用于控制计划任务的开关,一般来讲开关默认开启,当进行历史数据同步的时候,开关关闭
     */
    public static boolean trigger = true;

    @Autowired
    private AlertService alertService;

    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private RegionService regionService;

    private int count = 0;

    @Autowired
    private AlertRepository localPsspRep;


    /**
     * 抓取更新的网站的数据,当前为1h/次
     */
//    @EnablePsspSchProtect
    @Scheduled(cron = "0 0 0/1 * * ?")
    public void collectWebsiteData() {
        log.info("[pssp] [定时任务]抓取更新的网站数据");
        websiteService.fetchUpdatedData();
    }

    /**
     * 抓取更新的地区的数据,当前关闭
     */
//    @EnablePsspSchProtect
//    @Scheduled(cron = "0 0 0/1 * * ?")
    public void collectRegionData() {
        log.info("[pssp] [定时任务]抓取更新的区域数据");
        regionService.fetchUpdatedData();
    }

    /**
     * 抓取更新的报警数据,当前为1min15s/次
     */
//    @EnablePsspSchProtect
    @Scheduled(cron = "0 0/1 * * * ?")
    public void collectAlertData() {
        log.info("[pssp] [定时任务] 抓取更新的报警数据");
        alertService.fetchUpdatedData();

    }
}
