package com.zjty.fp.api.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;


/**
 * @author C
 * 报警记录
 * 一个报警表单中可以包含多条报警记录
 * routNo对应其所属的报警表单的statNO
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class ChkRoutes {
    /**
     * 主键ID
     */
    private Integer routID;

    /**
     * 状态码
     */
    private String routNO;

    /**
     * 状态码编号
     */
    private String routStatus;

    /**
     * 地区编号
     */
    private String routFrom;

    /**
     * 操作者,admin,不确定
     */
    private String routOperator;

    /**
     * 最后修改时间
     */
    private String routStamp;

    /**
     * 内容,数据库无数据,不确定
     */
    private String routMemo;

    /**
     * 操作者,不确定字段
     */
    private String routInspector;

    private String routInspectorX;

    private String routConcerned;

    private String routConcernedX;

    private Integer relationId;
}
