package com.zjty.fp.api.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author C
 * 处理记录
 * 一套报警记录中可以包含多条处理记录
 * chkNO对应其所属报警记录
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class PcLog {

    /**
     * 序号
     */
    private Integer recno;

    /**
     * 不详
     */
    private Integer serverId;

    /**
     * mac地址
     */
    private String macStr;

    /**
     * 主机名
     */
    private String hostname;

    /**
     * 不详
     */
    private Integer hostID;

    /**
     * 内网ip地址
     */
    private String ipStr;

    /**
     * 报警时间
     */
    private Date outbegin;

    /**
     * 报警时间,同outbegin字段
     */
    private Date outend;

    /**
     * 报警时间,精确到秒,string类型
     */
    private String strBegin;

    /**
     * 同strbegin字段
     */
    private String strEnd;

    /**
     * 无内容
     */
    private String tlocate;

    /**
     * 操作系统名称
     */
    private String tos;

    /**
     * 主板序列号
     */
    private String masterCode;

    /**
     * 硬盘序列号
     */
    private String hdCode;

    /**
     * 责任人
     */
    private String tUser;

    /**
     * 均为0
     */
    private Integer secLevel;

    /**
     * 用户端软件
     */
    private String tver;

    /**
     * 外联描述信息
     */
    private String tmemo;

    /**
     * 均为1
     */
    private String tmode;

    /**
     * 外网ip地址
     */
    private String outIpstr;

    /**
     * 地区名称
     */
    private String zoneCode;

    /**
     * 均为null
     */
    private String unitCode;

    /**
     * 单位名称
     */
    private String unitName;

    /**
     * 部门名称
     */
    private String deptment;

    /**
     * 1或0,意思不详
     */
    private Integer chkStatus;

    /**
     * 网卡信息
     */
    private String tCard;

    /**
     * 厂家编号
     */
    private String tCompany;

    /**
     * 转发
     */
    private String tReserve;

    /**
     * 时间类型,字义不知
     */
    private Date chkStamp;

    /**
     * 部门等级,不确定
     */
    private Integer unitType;

    /**
     * 操作人
     */
    private String chkOperator;

    /**
     * 均为null,用途不明
     */
    private String chkMemo;

    /**
     * 状态码,作关联用
     */
    private String chkNo;
}
