package com.zjty.fp.api.vomp.subject.entity.remotedo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author C
 * 地区
 * 里面包含
 * 监测终端数
 * 报警数
 * 报警率等等
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class Zone {

    /**
     * id,不知用途，有些为null
     */
    private String zoneId0;

    /**
     * 主id
     */
    private String zoneId;

    /**
     * 地区名字
     */
    private String zoneName;

    /**
     * 均为null
     */
    private String bmp;

    /**
     * 坐标x
     */
    private String xOrigin;

    /**
     * 坐标y
     */
    private String yOrigin;

    /**
     * 不详字段
     */
    private String xTerminus;

    /**
     * 不详字段
     */
    private String yTerminus;

    /**
     * 背景颜色
     */
    private String bg;

    /**
     * 父地区id
     */
    private String parentID;

    /**
     * 等级
     */
    private Integer levelID;

    /**
     * 不详字段
     */
    private Integer zoneCount;

    /**
     * 监控终端数量
     */
    private String zonePcCount;

    /**
     * 不详
     */
    private String xmls;

    /**
     * 0或1,不详
     */
    private Integer enterable;

    /**
     * 不详
     */
    private String zoneInformant;

    /**
     * 不详
     */
    private String zoneApproved;

    /**
     * 操作者,admin,null，不确定
     */
    private String zoneOperator;

    /**
     * 时间,用途不详
     */
    private String zoneStamp;

    /**
     * 涉密计算机数量
     */
    private String zonePaCount;
}
